IF EXISTS ( SELECT * FROM SYS.PROCEDURES WHERE NAME = 'P_CONSULTA_PRODUTO_PRECO_LIQ' )
BEGIN
	DROP PROCEDURE P_CONSULTA_PRODUTO_PRECO_LIQ
END
GO


CREATE PROC P_CONSULTA_PRODUTO_PRECO_LIQ
(	@DESC_CONSULTA  VARCHAR( 200 )
	, @TP_CONSULTA  INT                 -- 1 = PRODUTO NOME   2 = PRINCIPIO ATIVO   3 = PRODUTO NOME USUAL
	, @CD_EMP  INT     
	, @CD_FILIAL  INT  
	, @CD_CONV  INT   
	, @NR_CARTAO_FIDEL VARCHAR( 50 )  
	, @EAN  INT     
	, @CD_CLI  INT          
	, @QTDE_PROD  INT 
	, @APPLICATION  INT  
	, @ID_PROMO INT
	, @IS_RECEITA  INT
	, @CD_FRM_PGTO  INT
	, @CD_VEND  INT
	, @CD_PARCEIRO  INT
	, @TP_ORIG_VENDA  INT
	, @USA_DESCONTO_PROPZ_IDENT INT = 0
)

AS

/*
EXEC P_CONSULTA_PRODUTO_PRECO_LIQ 'CIMEGRIPE', 1 , 1 ,18, 0 , '0', 0, 0 , 1, 0, 0 ,0 ,1 ,0, 0,2
EXEC P_CONSULTA_PRODUTO_PRECO_LIQ '%%%DOVE', 1 , 1 ,18, 0 , '0', 0, 0 , 1, 0, 0 ,0 ,1 ,0, 0,2
EXEC P_CONSULTA_PRODUTO_PRECO_LIQ '%%DIPI', 2 , 1 ,18, 0 , '0', 0, 0 , 1, 0, 0 ,0 ,1 ,0, 0,2
*/

SET NOCOUNT ON

DECLARE @VAR_CD_PROD  INT


DECLARE @TEMP_CODS_PRODUTO TABLE 
         ( CD_PROD INT )
	
DECLARE @TEMP_RS_PRODUTO_POOL TABLE
         (
		VERSAO VARCHAR(100)
		,CD_EMP INT
		,CD_FILIAL INT
		,CD_PROD INT
		,DS_PROD VARCHAR(100)
		,NM_FABRIC VARCHAR(100)
		,VLR_TABELA MONEY
		,VLR_OFERTA MONEY
		,QTDE_PONTO_FIDEL MONEY
		,CTR_PMC INT
		,LIB_DESC_VERBA INT
		,FLAG_REQUER_RECEIT INT
		,FLAG_ALTERAR_PRECO INT
		,PROD_USO_CONT INT
		,TP_PROD INT
		,VLR_CUSTO MONEY
		,CD_GRP INT
		,QTD_PONTO_VENDA MONEY
		,LMT_PROD_PONTO_VENDA MONEY
		,APRES_QT_VD INT
		,QTDE_ESTOQUE MONEY
		,DS_TIPO_RECEITA VARCHAR(100)
		,DS_COR_RECEITA VARCHAR(100)
		,PERC_DESC_LIMITE MONEY
		,CD_TRIB_FC VARCHAR(3)
		,PERC_ICMS_N_CONT_ESTA MONEY
		,PERC_RED_VD MONEY
		,LIBERA_VD_CONV INT
		,QTDE_PROD_MAX_CONV INT
		,FIXA_DESCONTO INT
		,TP_DESCONTO INT
		,VLR_ECONOMIA MONEY
		,DS_DESCONTO VARCHAR(150)
		,CD_TBL_DESC INT
		,TP_NIVEL INT
		,PERC_DESC MONEY
		,MAIOR_PERC_DESC MONEY
		,PRODUTO_CONTROLADO INT
		,VLR_PMC MONEY	
-- AVALIAR COLUNAS ABAIXO
		,FLAG_DESCONTO_TICKET_BLQ INT
		,PERC_DESC_FIDEL_MAX MONEY
		,PROMO_INDUSTRIA INT
		,PERC_DESC_ANIVER MONEY
		,PERC_DESC_CLAS MONEY
		,VLR_DESC_FABRIC MONEY
		,CAMPANHA INT
		,QTDE_PROD_CAMPANHA INT
		,FLAG_BLOQUEIA_DESCONTO INT
		,PERC_DESC_POS_PBM DECIMAL(6, 4)
		,CD_FAMILIA INT
		,NCM_PROD VARCHAR(50)
		,NR_REG_MS VARCHAR(150)
		,TP_TBL_DESC  INT DEFAULT ( 3 )
		,QTDE_LIMITE_VENDA_FAMILIA INT
		,DS_FAMILIA VARCHAR(255)
		,PERC_PIS MONEY
		,PERC_COFINS MONEY	
		)



INSERT INTO @TEMP_CODS_PRODUTO
--DECLARE 	@DESC_CONSULTA  VARCHAR( 200 ) = 'CIMEGRIPE'	, @TP_CONSULTA  INT = 1 , @CD_EMP INT = 1 	, @CD_FILIAL  INT    = 18
SELECT TOP 300 
		P.CD_PROD 
--, C.TP_PROD , PEND.*
	FROM EST_PROD  P
	JOIN EST_PROD_CPL  C
		ON C.CD_EMP  = P.CD_EMP
		AND C.CD_FILIAL = @CD_FILIAL
		AND C.CD_PROD = P.CD_PROD
	JOIN EST_PROD_PRECO  PR
		ON PR.CD_EMP = C.CD_EMP
		AND PR.CD_FILIAL = C.CD_FILIAL
		AND PR.CD_PROD = C.CD_PROD
   LEFT JOIN EST_PROD_PRINC_ATIVOS_EST_PROD PPA 
      ON PPA.CD_EMP = P.CD_EMP 
      AND PPA.CD_PROD = P.CD_PROD 
   LEFT JOIN EST_PROD_PRINC_ATIVOS PA 
      ON PA.CD_PRINC_ATIVOS = PPA.CD_PRINC_ATIVOS
	JOIN V_EST_PROD_CPL_PENDENCIAS PEND ON C.CD_EMP = PEND.CD_EMP
														AND C.CD_FILIAL = PEND.CD_FILIAL
														AND C.CD_PROD = PEND.CD_PROD
   WHERE P.CD_EMP = 1
		AND C.CD_FILIAL = @CD_FILIAL
      AND P.STS_PROD IN ( 0 , 2 )
		AND PEND.STS_PROD_FILIAL IN ( 0 , 2 )   ---- VER AQUI
      AND C.TP_PROD IN (0,9,10,11)
		AND P.STS_PROD_CALL_CENTER = 0
		AND PR.VLR_TABELA > 0
      AND P.CD_FILIAL >= 0
      AND ( ( @TP_CONSULTA = 1 AND UPPER(P.DS_PROD) LIKE CONCAT( @DESC_CONSULTA , '%' ) )
         OR ( @TP_CONSULTA = 2 AND UPPER(COALESCE(PA.DS_PRINC_ATIVOS,'')) LIKE CONCAT( @DESC_CONSULTA , '%' ) ) 
         OR ( @TP_CONSULTA = 3 AND UPPER(P.DS_USUAL) LIKE CONCAT( @DESC_CONSULTA , '%' ) ) 
         )

-----------------PROCESSAMENTO DA PROCEDURE------------------------------------------------

WHILE EXISTS (  SELECT TOP 1 1 FROM @TEMP_CODS_PRODUTO ORDER BY CD_PROD )  
BEGIN

   SET @VAR_CD_PROD = (SELECT TOP 1 CD_PROD FROM @TEMP_CODS_PRODUTO ORDER BY CD_PROD )

   INSERT INTO @TEMP_RS_PRODUTO_POOL
   EXEC P_EST_PROD_DESCONTOS
		@CD_EMP  = @CD_EMP
		, @CD_FILIAL  = @CD_FILIAL
		, @CD_PROD   = @VAR_CD_PROD
		, @CD_CONV   = @CD_CONV
		, @NR_CARTAO_FIDEL = @NR_CARTAO_FIDEL
		, @EAN    = @EAN
		, @CD_CLI  = @CD_CLI
		, @QTDE_PROD    = @QTDE_PROD
		, @APPLICATION  = @APPLICATION
		, @ID_PROMO    = @ID_PROMO
		, @IS_RECEITA  =  @IS_RECEITA
		, @CD_FRM_PGTO  = @CD_FRM_PGTO
		, @IGNORED   = 0
		, @CD_VEND   = @CD_VEND
		, @CD_PARCEIRO  = @CD_PARCEIRO
		, @TP_ORIG_VENDA  = @TP_ORIG_VENDA
		, @USA_DESCONTO_PROPZ_IDENT = @USA_DESCONTO_PROPZ_IDENT	
   DELETE FROM @TEMP_CODS_PRODUTO
      WHERE CD_PROD = @VAR_CD_PROD

END
		
SELECT DISTINCT --TOP 300    --- FILTRADO TIP NOS CODIGOS PARA CALCULO DO LIQUIDO
		EST_PROD.CD_PROD AS 'CÓDIGO',  EST_PROD.DS_PROD  AS 'PRODUTO',  
		CONVERT(DECIMAL(12,2),EST_PROD_PRECO.VLR_OFERTA) AS 'OFERTA',  
		CONVERT(DECIMAL(12,2),EST_PROD_PRECO.VLR_TABELA) AS 'VENDA', 
		CONVERT( DECIMAL( 12 ,2 ) , COALESCE(EST_PROD_PRECO.VLR_TABELA,0.00)
									- (COALESCE(EST_PROD_PRECO.VLR_TABELA,0.00)*(T.PERC_DESC/100.00) ) ) AS 'LIQUIDO', 
		CONVERT(DECIMAL(12,2),
		CASE COALESCE((SELECT COALESCE(CAST(VALOR AS INT), 0) FROM PRC_EMP_CONFIG WHERE CD_EMP = 1 AND CD_CHAVE LIKE 'CTR_CUSTO_SEMAFORO'), 0) 
			WHEN 0 
				THEN EST_PROD_CPL.VLR_CUSTO 
				ELSE EST_PROD_CPL.VLR_CUSTO_MD 
			END) 'CUSTO', 
		(SELECT CAST(COALESCE(SUM(QT_EST), 0)AS INT) 
			FROM EST_PROD_CPL      
			WHERE CD_EMP = 1 
				AND CD_PROD = EST_PROD.CD_PROD  
				AND QT_EST > 0 
				AND CD_FILIAL IN 
						(SELECT CD_FILIAL 
							FROM TELE_PRC_FILIAL A 
							WHERE  CD_EMP = 1 
							AND A.FILIAL_POLO = 1 )) 'EST. POLOS',  
		SUBSTRING(EST_PROD_FABRIC.NM_FABRIC,1,20) 'FABRICANTE',  
		CASE ISNULL(EST_PROD_FARMACIA_POPULAR.CD_PROD,0) WHEN 0 THEN '' ELSE 'F.POP' END 'F.POP',  
		DS_ARV_MERC_LINHA 'LINHA',  
		DS_PRINC_ATIVOS 'PRINC.ATIVO',  
		CASE WHEN ISNULL(EST_PROD_CPL.FLAG_VERBA_DESCON,0) > 0 THEN EST_PROD_CPL.FLAG_VERBA_DESCON ELSE EST_PROD.FLAG_VERBA_DESCON END  'DESC.VERBA',  
		CASE 
			WHEN ISNULL(FLAG_PRODUTO_CONTROLADO, 0) > 0 THEN 
					ISNULL((SELECT ISNULL(VALOR, 0) FROM PRC_EMP_CONFIG WHERE CD_EMP = 1 AND  CD_CHAVE = 'BLOQUEIA_VD_CONTROLADO_TELEVENDAS'),0) 
				ELSE 0 
			END AS 'BLOQUEADO' 
      --, CAST( COALESCE(EST_GRP_COMIS_PDV.DS_GRP ,'NAO INFORMADO') AS VARCHAR(100) ) AS GRUPO_COMISSAO
	  ,T.PERC_ICMS_N_CONT_ESTA
	  ,T.PERC_RED_VD
	  ,T.PERC_PIS
	  ,T.PERC_COFINS
   FROM @TEMP_RS_PRODUTO_POOL  T
   INNER JOIN EST_PROD_CPL  
      ON EST_PROD_CPL.CD_EMP = T.CD_EMP 
      AND EST_PROD_CPL.CD_FILIAL = T.CD_FILIAL 
      AND EST_PROD_CPL.CD_PROD = T.CD_PROD
   INNER JOIN EST_PROD_PRECO 
      ON EST_PROD_CPL.CD_EMP = EST_PROD_PRECO.CD_EMP 
      AND EST_PROD_CPL.CD_FILIAL = EST_PROD_PRECO.CD_FILIAL 
      AND EST_PROD_CPL.CD_PROD = EST_PROD_PRECO.CD_PROD 
   INNER JOIN EST_PROD 
      ON EST_PROD_CPL.CD_EMP = EST_PROD.CD_EMP 
      AND EST_PROD_CPL.CD_PROD = EST_PROD.CD_PROD 
   LEFT JOIN EST_PROD_FABRIC 
      ON EST_PROD.CD_FABRIC = EST_PROD_FABRIC.CD_FABRIC 
   LEFT JOIN EST_PROD_PRT 
      ON EST_PROD_PRT.CD_PRT = EST_PROD_CPL.PRAT 
   LEFT JOIN EST_PROD_CPL_CAMP_BRINDE 
      ON EST_PROD_CPL_CAMP_BRINDE.CD_PROD = EST_PROD.CD_PROD 
   LEFT JOIN EST_PROD_PRINC_ATIVOS_EST_PROD 
      ON EST_PROD_CPL.CD_PROD = EST_PROD_PRINC_ATIVOS_EST_PROD.CD_PROD 
   LEFT JOIN EST_PROD_PRINC_ATIVOS 
      ON EST_PROD_PRINC_ATIVOS_EST_PROD.CD_PRINC_ATIVOS = EST_PROD_PRINC_ATIVOS.CD_PRINC_ATIVOS 
   --LEFT JOIN EST_GRP_COMIS_PDV_CPL 
   --   ON EST_PROD_CPL.CD_EMP = EST_GRP_COMIS_PDV_CPL.CD_EMP 
   --   AND EST_PROD_CPL.CD_FILIAL = EST_GRP_COMIS_PDV_CPL.CD_FILIAL 
   --   AND EST_PROD_CPL.CD_PROD = EST_GRP_COMIS_PDV_CPL.CD_PROD 
   --LEFT JOIN EST_GRP_COMIS_PDV 
   --   ON EST_GRP_COMIS_PDV_CPL.CD_EMP = EST_GRP_COMIS_PDV.CD_EMP 
   --   AND EST_GRP_COMIS_PDV_CPL.CD_GRP = EST_GRP_COMIS_PDV.CD_GRP 
	LEFT JOIN EST_PROD_EST_ARV_MERCADOLOGICA 
		ON EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP = EST_PROD.CD_EMP 
		AND EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD = EST_PROD.CD_PROD  
	LEFT JOIN EST_PROD_FARMACIA_POPULAR 
		ON EST_PROD_FARMACIA_POPULAR.CD_EMP = EST_PROD_CPL.CD_EMP
		AND EST_PROD_FARMACIA_POPULAR.CD_FILIAL = EST_PROD_CPL.CD_FILIAL  
		AND EST_PROD_FARMACIA_POPULAR.CD_PROD = EST_PROD_CPL.CD_PROD  
	LEFT JOIN EST_ARV_MERC_LINHA 
		ON EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA = EST_ARV_MERC_LINHA.CD_ARV_MERC_LINHA  
   WHERE EST_PROD.STS_PROD <> 1  
      AND (EST_PROD.FLAG_VD_CALL_CENTER = 0 OR EST_PROD.FLAG_VD_CALL_CENTER IS NULL) 
      AND EST_PROD_CPL.TP_PROD IN (0,9,10,11)  
      AND EST_PROD_CPL_CAMP_BRINDE.CD_PROD IS NULL
   ORDER BY EST_PROD.DS_PROD

GO

